﻿/**********************************************************

ADOBE SYSTEMS INCORPORATED 
Copyright 2005-2010 Adobe Systems Incorporated 
All Rights Reserved 

NOTICE:  Adobe permits you to use, modify, and 
distribute this file in accordance with the terms
of the Adobe license agreement accompanying it.  
If you have received this file from a source 
other than Adobe, then your use, modification,
or distribution of it requires the prior 
written permission of Adobe. 

*********************************************************/

/**********************************************************
 
MakeRadialGradient.jsx

DESCRIPTION

This Sample creates a radial gradient and adds it to the Swatches 
palette then applies it to a new path item in a new document.
It shows the use of the PathItems and GradientStops collections, 
RGBColor, Gradient and GradientStop objects.

**********************************************************/

// Open a new document
var docRef = app.documents.add();

// Create a new path item in the new document
var pathRef = docRef.pathItems.rectangle (700, 100, 300, 300, false);

// Call createGradient function to create gradient myGradient
var myGradient = createGradient();

// Apply gradient myGradient new path item
pathRef.filled = true;
pathRef.fillColor = myGradient;
redraw();

/*********************************************************
 
createGradient: Function to create a new radial gradient 
with 6 GradientStops

**********************************************************/

function createGradient()
{

	// Create a new gradient
	// A new gradient always has 2 stops
	var theGradient = app.activeDocument.gradients.add();
	theGradient.name = "MyRadialGradient";
	theGradient.type = GradientType.RADIAL;	
	
	// Add 2 new gradient stops
	var newStop1 = theGradient.gradientStops.add();
	var newStop2 = theGradient.gradientStops.add();
	var newStop3 = theGradient.gradientStops.add();
	var newStop4 = theGradient.gradientStops.add();
	
	// Create color objects for all the gradient stops
	var startColor = new CMYKColor();
	var newStop1Color = new CMYKColor();
	var newStop2Color = new CMYKColor();
	var newStop3Color = new CMYKColor();
	var newStop4Color = new CMYKColor();
	var endColor = new CMYKColor();
	startColor.cyan = 1;
	startColor.magenta = 96;
	startColor.yellow = 91;
	startColor.black = 0;
	newStop1Color.cyan = 3;
	newStop1Color.magenta = 1;
	newStop1Color.yellow = 91;
	newStop1Color.black = 0;
	newStop2Color.cyan = 92;
	newStop2Color.magenta = 7;
	newStop2Color.yellow = 93;
	newStop2Color.black = 0;
	newStop3Color.cyan = 0;
	newStop3Color.magenta = 98;
	newStop3Color.yellow = 3;
	newStop3Color.black = 0;
	newStop4Color.cyan = 97;
	newStop4Color.magenta = 98;
	newStop4Color.yellow = 1;
	newStop4Color.black = 0;
	endColor.cyan = 90;
	endColor.magenta = 7;
	endColor.yellow = 3;		
	endColor.black = 0;
	
	// Modify the first gradient stop
	theGradient.gradientStops[0].rampPoint = 0;
	theGradient.gradientStops[0].midPoint = 50;
	theGradient.gradientStops[0].color = startColor;	
	
	// Modify newStop1
	theGradient.gradientStops[1].rampPoint = 20;
	theGradient.gradientStops[1].midPoint = 50;
	theGradient.gradientStops[1].color = newStop1Color;
	theGradient.gradientStops[1].opacity = 20;
	
	// Modify newStop2
	theGradient.gradientStops[2].rampPoint = 40;
	theGradient.gradientStops[2].midPoint = 50;
	theGradient.gradientStops[2].color = newStop2Color;
	theGradient.gradientStops[2].opacity = 40;
	
	// Modify newStop3
	theGradient.gradientStops[3].rampPoint = 60;
	theGradient.gradientStops[3].midPoint = 50;
	theGradient.gradientStops[3].color = newStop3Color;
	theGradient.gradientStops[3].opacity = 40;
	
	// Modify newStop4
	theGradient.gradientStops[4].rampPoint = 80;
	theGradient.gradientStops[4].midPoint = 50;
	theGradient.gradientStops[4].color = newStop4Color;
	theGradient.gradientStops[4].opacity = 20;

	// Modify the last gradient stop
	theGradient.gradientStops[5].rampPoint = 100;
	theGradient.gradientStops[5].color = endColor;	
	
	// Construct an Illustrator.GradientColor object referring to the
	// newly created gradient
	var myGradientColor = new GradientColor();
	myGradientColor.gradient = theGradient;
	return myGradientColor;
}